/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CommandProcessor;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceManager;
import jade.core.ServiceManagerImpl;
import jade.core.VerticalCommand;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Map;
import jade.util.leap.Serializable;

public abstract class BaseNode
implements Node,
Serializable {
    private Logger myLogger;
    protected transient ServiceManager myServiceManager;
    private transient CommandProcessor processor;
    private String myName;
    private boolean hasLocalPM = false;
    private transient Map localSlices;

    public BaseNode(String name, boolean hasPM) {
        this.myName = name;
        this.hasLocalPM = hasPM;
        this.localSlices = new HashMap(5);
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public boolean hasPlatformManager() {
        return this.hasLocalPM;
    }

    public void exportSlice(String serviceName, Service.Slice localSlice) {
        this.localSlices.put(serviceName, localSlice);
    }

    public void unexportSlice(String serviceName) {
        this.localSlices.remove(serviceName);
    }

    protected Service.Slice getSlice(String serviceName) {
        return (Service.Slice)this.localSlices.get(serviceName);
    }

    public Object serveHorizontalCommand(HorizontalCommand cmd) throws ServiceException {
        Service.Slice slice;
        String serviceName = cmd.getService();
        String commandName = cmd.getName();
        Object[] commandParams = cmd.getParams();
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Node " + this.myName + " serving incoming H-Command " + commandName + " of Service " + serviceName);
        }
        if ((slice = this.getSlice(serviceName)) != null) {
            Object ret = null;
            VerticalCommand vCmd = slice.serve(cmd);
            if (vCmd != null) {
                vCmd.setPrincipal(cmd.getPrincipal());
                vCmd.setCredentials(cmd.getCredentials());
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Node " + this.myName + " issuing incoming V-Command " + vCmd.getName() + " of Service " + vCmd.getService());
                }
                this.serveVerticalCommand(vCmd);
                ret = vCmd.getReturnValue();
            } else {
                ret = cmd.getReturnValue();
            }
            if (ret != null && this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Node " + this.myName + " return value for incoming H-Command " + commandName + " of Service " + serviceName + " = " + ret);
            }
            return ret;
        }
        String s = new String("Node " + this.myName + ": Service " + serviceName + " Unknown. Command = " + commandName);
        throw new ServiceException("-- " + s + " --");
    }

    public void setCommandProcessor(CommandProcessor cp) {
        this.processor = cp;
    }

    public void setServiceManager(ServiceManager mgr) {
        this.myServiceManager = mgr;
    }

    public void platformManagerDead(String deadPMAddr, String notifyingPMAddr) throws IMTPException {
        if (deadPMAddr.equals(notifyingPMAddr)) {
            ((ServiceManagerImpl)this.myServiceManager).reattach(notifyingPMAddr);
        } else {
            this.myServiceManager.addAddress(notifyingPMAddr);
            this.myServiceManager.removeAddress(deadPMAddr);
        }
    }

    private Object serveVerticalCommand(VerticalCommand cmd) throws ServiceException {
        if (this.processor == null) {
            throw new ServiceException("No command processor for node <" + this.getName() + ">");
        }
        return this.processor.processIncoming(cmd);
    }

    public String toString() {
        return this.myName;
    }
}

